﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
#include "gameFunctions/nestedEval.as"
#include "functions/sendEvent.as"
#include "functions/getImpliedValue.as"
// run()
//var TRACE_EVENT = true;
define_event = function( thisCommand_obj ){
	var thisContainer_str = "_this";
	var defaultContainer_str = "RAM";
	
	// LEGACY
	if( thisCommand_obj.data.name === "undefined" )
		delete thisCommand_obj.data.name;
	// if "name" exists, append it to "path"
	if( typeof( thisCommand_obj.data.name ) === "string"  &&  thisCommand_obj.data.name.length > 0 ){
		thisCommand_obj.data.path += '.' + thisCommand_obj.data.name;
		if(TRACE_SCRIPT || TRACE_EVENT)			trace(" 'event' command detected 'name'.  Now appending name to path.  Result is: " + thisCommand_obj.data.path );
	}
	// "name" should not exist anymore
	delete thisCommand_obj.data.name;
	
	
	// resolve [variables]
	var fullPath_str = nestedEval( thisCommand_obj.data.path, defaultContainer_str, thisContainer_str );
	
	// check whether a location is specified for the event
	var evtAt = fullPath_str.lastIndexOf('.');
	if( evtAt === -1 ){
		// if the path has no location
		// then add a location, as this
		fullPath_str = "this." + fullPath_str;
		evtAt = 5;
	}
	// extract the event location
	var path_str = fullPath_str.substr( 0, evtAt );		// get everything before that .
	// extract the event name
	var evt_str = fullPath_str.substr( evtAt + 1 );		// get everything after that .
	
	
	// Sanity check
	var isValid = true;
	if( !evt_str )		isValid = false;
	
	if( isValid ){
		// Get the object where the event should occur
		var path = "[" + path_str + "]";		// Always assume the path is a variable-path to something
		var evtEmitter = nestedEval( path, defaultContainer_str, thisContainer_str );
		var emitterIsObject = ( evtEmitter instanceof Object );
		if( !emitterIsObject )		evtEmitter = undefined;
		
		// Get variables to send with the event
		var evt = {};
		evt.type = evt_str;
		var dat = thisCommand_obj.data.data;
		for( var nam in dat ){
			var val = nestedEval(  dat[ nam ],  defaultContainer_str, thisContainer_str );
			evt[ nam ] = getImpliedValue( val );
		} // for:  each variable to send with the event
		delete val;
		
		// Debug trace
		if(TRACE_SCRIPT || TRACE_EVENT){
			trace("event:  "+thisCommand_obj.data.path );
			trace(" resolved event location: " + path_str );
			trace(" resolved event name: " + evt_str );
			trace(" emitter: " );
			trace( evtEmitter );
			/*	
			trace("event:  "+thisCommand_obj.data.name + "  ("+thisCommand_obj.data.path+")  Listing evt contents:");
			for( var nam in evt ){
				trace( "  " + nam + ":  " + evt[ nam ]  );
				for( var nam2 in evt[ nam ] ){
					trace( "    " + nam2 + ":  " + evt[ nam ][ nam2 ]  );
				} 
			}// each item in evt
			trace( "- - - -" );
			*/
		}// if:  TRACE_SCRIPT
		
		// Send the event itself
		sendEvent( evt_str, evt, evtEmitter );
	} // if:  data is valid
	
	
	// instantly done
	return VOW.make().keep();
	
	
}// define_event()